/**
 * @license almond 0.3.3 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, http://github.com/requirejs/almond/LICENSE
 */

/*
    This program is distributed under the terms of the MIT license.
    Please see the LICENSE file for details.

    Copyright 2006-2008, OGG, LLC
*/

/*
 * A JavaScript implementation of the Secure Hash Algorithm, SHA-1, as defined
 * in FIPS PUB 180-1
 * Version 2.1a Copyright Paul Johnston 2000 - 2002.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for details.
 */

/*
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.1 Copyright (C) Paul Johnston 1999 - 2002.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */

!function(t,e){if("function"==typeof define&&define.amd)define([],e);else{var n=e();t.Strophe=n.Strophe,t.$build=n.$build,t.$iq=n.$iq,t.$msg=n.$msg,t.$pres=n.$pres,t.SHA1=n.SHA1,t.MD5=n.MD5,t.b64_hmac_sha1=n.b64_hmac_sha1,t.b64_sha1=n.b64_sha1,t.str_hmac_sha1=n.str_hmac_sha1,t.str_sha1=n.str_sha1}}(this,function(){var t,e,n;return function(s){function i(t,e){return v.call(t,e)}function r(t,e){var n,s,i,r,o,a,h,c,u,l,d,p,f=e&&e.split("/"),_=b.map,m=_&&_["*"]||{};if(t){for(t=t.split("/"),o=t.length-1,b.nodeIdCompat&&T.test(t[o])&&(t[o]=t[o].replace(T,"")),"."===t[0].charAt(0)&&f&&(p=f.slice(0,f.length-1),t=p.concat(t)),u=0;u<t.length;u++)if(d=t[u],"."===d)t.splice(u,1),u-=1;else if(".."===d){if(0===u||1===u&&".."===t[2]||".."===t[u-1])continue;u>0&&(t.splice(u-1,2),u-=2)}t=t.join("/")}if((f||m)&&_){for(n=t.split("/"),u=n.length;u>0;u-=1){if(s=n.slice(0,u).join("/"),f)for(l=f.length;l>0;l-=1)if(i=_[f.slice(0,l).join("/")],i&&(i=i[s])){r=i,a=u;break}if(r)break;!h&&m&&m[s]&&(h=m[s],c=u)}!r&&h&&(r=h,a=c),r&&(n.splice(0,a,r),t=n.join("/"))}return t}function o(t,e){return function(){var n=x.call(arguments,0);return"string"!=typeof n[0]&&1===n.length&&n.push(null),f.apply(s,n.concat([t,e]))}}function a(t){return function(e){return r(e,t)}}function h(t){return function(e){g[t]=e}}function c(t){if(i(S,t)){var e=S[t];delete S[t],y[t]=!0,p.apply(s,e)}if(!i(g,t)&&!i(y,t))throw new Error("No "+t);return g[t]}function u(t){var e,n=t?t.indexOf("!"):-1;return n>-1&&(e=t.substring(0,n),t=t.substring(n+1,t.length)),[e,t]}function l(t){return t?u(t):[]}function d(t){return function(){return b&&b.config&&b.config[t]||{}}}var p,f,_,m,g={},S={},b={},y={},v=Object.prototype.hasOwnProperty,x=[].slice,T=/\.js$/;_=function(t,e){var n,s=u(t),i=s[0],o=e[1];return t=s[1],i&&(i=r(i,o),n=c(i)),i?t=n&&n.normalize?n.normalize(t,a(o)):r(t,o):(t=r(t,o),s=u(t),i=s[0],t=s[1],i&&(n=c(i))),{f:i?i+"!"+t:t,n:t,pr:i,p:n}},m={require:function(t){return o(t)},exports:function(t){var e=g[t];return"undefined"!=typeof e?e:g[t]={}},module:function(t){return{id:t,uri:"",exports:g[t],config:d(t)}}},p=function(t,e,n,r){var a,u,d,p,f,b,v,x=[],T=typeof n;if(r=r||t,b=l(r),"undefined"===T||"function"===T){for(e=!e.length&&n.length?["require","exports","module"]:e,f=0;f<e.length;f+=1)if(p=_(e[f],b),u=p.f,"require"===u)x[f]=m.require(t);else if("exports"===u)x[f]=m.exports(t),v=!0;else if("module"===u)a=x[f]=m.module(t);else if(i(g,u)||i(S,u)||i(y,u))x[f]=c(u);else{if(!p.p)throw new Error(t+" missing "+u);p.p.load(p.n,o(r,!0),h(u),{}),x[f]=g[u]}d=n?n.apply(g[t],x):void 0,t&&(a&&a.exports!==s&&a.exports!==g[t]?g[t]=a.exports:d===s&&v||(g[t]=d))}else t&&(g[t]=n)},t=e=f=function(t,e,n,i,r){if("string"==typeof t)return m[t]?m[t](e):c(_(t,l(e)).f);if(!t.splice){if(b=t,b.deps&&f(b.deps,b.callback),!e)return;e.splice?(t=e,e=n,n=null):t=s}return e=e||function(){},"function"==typeof n&&(n=i,i=r),i?p(s,t,e,n):setTimeout(function(){p(s,t,e,n)},4),f},f.config=function(t){return f(t)},t._defined=g,n=function(t,e,n){if("string"!=typeof t)throw new Error("See almond README: incorrect module build, no module name");e.splice||(n=e,e=[]),i(g,t)||i(S,t)||(S[t]=[t,e,n])},n.amd={jQuery:!0}}(),n("node_modules/almond/almond.js",function(){}),function(t,e){return"function"==typeof n&&n.amd?void n("strophe-polyfill",[],function(){return e(t)}):e(t)}(this,function(t){Function.prototype.bind||(Function.prototype.bind=function(t){var e=this,n=Array.prototype.slice,s=Array.prototype.concat,i=n.call(arguments,1);return function(){return e.apply(t?t:this,s.call(i,n.call(arguments,0)))}}),Array.isArray||(Array.isArray=function(t){return"[object Array]"===Object.prototype.toString.call(t)}),Array.prototype.indexOf||(Array.prototype.indexOf=function(t){var e=this.length,n=Number(arguments[1])||0;for(n=n<0?Math.ceil(n):Math.floor(n),n<0&&(n+=e);n<e;n++)if(n in this&&this[n]===t)return n;return-1}),Array.prototype.forEach||(Array.prototype.forEach=function(t,e){var n,s;if(null===this)throw new TypeError(" this is null or not defined");var i=Object(this),r=i.length>>>0;if("function"!=typeof t)throw new TypeError(t+" is not a function");for(arguments.length>1&&(n=e),s=0;s<r;){var o;s in i&&(o=i[s],t.call(n,o,s,i)),s++}});var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";t.btoa||(t.btoa=function(t){var n,s,i,r,o,a,h,c="",u=0;do n=t.charCodeAt(u++),s=t.charCodeAt(u++),i=t.charCodeAt(u++),r=n>>2,o=(3&n)<<4|s>>4,a=(15&s)<<2|i>>6,h=63&i,isNaN(s)?(o=(3&n)<<4,a=h=64):isNaN(i)&&(h=64),c=c+e.charAt(r)+e.charAt(o)+e.charAt(a)+e.charAt(h);while(u<t.length);return c}),t.atob||(t.atob=function(t){var n,s,i,r,o,a,h,c="",u=0;t=t.replace(/[^A-Za-z0-9\+\/\=]/g,"");do r=e.indexOf(t.charAt(u++)),o=e.indexOf(t.charAt(u++)),a=e.indexOf(t.charAt(u++)),h=e.indexOf(t.charAt(u++)),n=r<<2|o>>4,s=(15&o)<<4|a>>2,i=(3&a)<<6|h,c+=String.fromCharCode(n),64!==a&&(c+=String.fromCharCode(s)),64!==h&&(c+=String.fromCharCode(i));while(u<t.length);return c})}),function(t,e){"function"==typeof n&&n.amd?n("strophe-sha1",[],function(){return e()}):"object"==typeof exports?module.exports=e():t.SHA1=e()}(this,function(){function t(t,s){t[s>>5]|=128<<24-s%32,t[(s+64>>9<<4)+15]=s;var o,a,h,c,u,l,d,p,f=new Array(80),_=1732584193,m=-271733879,g=-1732584194,S=271733878,b=-1009589776;for(o=0;o<t.length;o+=16){for(c=_,u=m,l=g,d=S,p=b,a=0;a<80;a++)a<16?f[a]=t[o+a]:f[a]=r(f[a-3]^f[a-8]^f[a-14]^f[a-16],1),h=i(i(r(_,5),e(a,m,g,S)),i(i(b,f[a]),n(a))),b=S,S=g,g=r(m,30),m=_,_=h;_=i(_,c),m=i(m,u),g=i(g,l),S=i(S,d),b=i(b,p)}return[_,m,g,S,b]}function e(t,e,n,s){return t<20?e&n|~e&s:t<40?e^n^s:t<60?e&n|e&s|n&s:e^n^s}function n(t){return t<20?1518500249:t<40?1859775393:t<60?-1894007588:-899497514}function s(e,n){var s=o(e);s.length>16&&(s=t(s,8*e.length));for(var i=new Array(16),r=new Array(16),a=0;a<16;a++)i[a]=909522486^s[a],r[a]=1549556828^s[a];var h=t(i.concat(o(n)),512+8*n.length);return t(r.concat(h),672)}function i(t,e){var n=(65535&t)+(65535&e),s=(t>>16)+(e>>16)+(n>>16);return s<<16|65535&n}function r(t,e){return t<<e|t>>>32-e}function o(t){for(var e=[],n=255,s=0;s<8*t.length;s+=8)e[s>>5]|=(t.charCodeAt(s/8)&n)<<24-s%32;return e}function a(t){for(var e="",n=255,s=0;s<32*t.length;s+=8)e+=String.fromCharCode(t[s>>5]>>>24-s%32&n);return e}function h(t){for(var e,n,s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",i="",r=0;r<4*t.length;r+=3)for(e=(t[r>>2]>>8*(3-r%4)&255)<<16|(t[r+1>>2]>>8*(3-(r+1)%4)&255)<<8|t[r+2>>2]>>8*(3-(r+2)%4)&255,n=0;n<4;n++)i+=8*r+6*n>32*t.length?"=":s.charAt(e>>6*(3-n)&63);return i}return{b64_hmac_sha1:function(t,e){return h(s(t,e))},b64_sha1:function(e){return h(t(o(e),8*e.length))},binb2str:a,core_hmac_sha1:s,str_hmac_sha1:function(t,e){return a(s(t,e))},str_sha1:function(e){return a(t(o(e),8*e.length))}}}),function(t,e){"function"==typeof n&&n.amd?n("strophe-md5",[],function(){return e()}):"object"==typeof exports?module.exports=e():t.MD5=e()}(this,function(){var t=function(t,e){var n=(65535&t)+(65535&e),s=(t>>16)+(e>>16)+(n>>16);return s<<16|65535&n},e=function(t,e){return t<<e|t>>>32-e},n=function(t){for(var e=[],n=0;n<8*t.length;n+=8)e[n>>5]|=(255&t.charCodeAt(n/8))<<n%32;return e},s=function(t){for(var e="",n=0;n<32*t.length;n+=8)e+=String.fromCharCode(t[n>>5]>>>n%32&255);return e},i=function(t){for(var e="0123456789abcdef",n="",s=0;s<4*t.length;s++)n+=e.charAt(t[s>>2]>>s%4*8+4&15)+e.charAt(t[s>>2]>>s%4*8&15);return n},r=function(n,s,i,r,o,a){return t(e(t(t(s,n),t(r,a)),o),i)},o=function(t,e,n,s,i,o,a){return r(e&n|~e&s,t,e,i,o,a)},a=function(t,e,n,s,i,o,a){return r(e&s|n&~s,t,e,i,o,a)},h=function(t,e,n,s,i,o,a){return r(e^n^s,t,e,i,o,a)},c=function(t,e,n,s,i,o,a){return r(n^(e|~s),t,e,i,o,a)},u=function(e,n){e[n>>5]|=128<<n%32,e[(n+64>>>9<<4)+14]=n;for(var s,i,r,u,l=1732584193,d=-271733879,p=-1732584194,f=271733878,_=0;_<e.length;_+=16)s=l,i=d,r=p,u=f,l=o(l,d,p,f,e[_+0],7,-680876936),f=o(f,l,d,p,e[_+1],12,-389564586),p=o(p,f,l,d,e[_+2],17,606105819),d=o(d,p,f,l,e[_+3],22,-1044525330),l=o(l,d,p,f,e[_+4],7,-176418897),f=o(f,l,d,p,e[_+5],12,1200080426),p=o(p,f,l,d,e[_+6],17,-1473231341),d=o(d,p,f,l,e[_+7],22,-45705983),l=o(l,d,p,f,e[_+8],7,1770035416),f=o(f,l,d,p,e[_+9],12,-1958414417),p=o(p,f,l,d,e[_+10],17,-42063),d=o(d,p,f,l,e[_+11],22,-1990404162),l=o(l,d,p,f,e[_+12],7,1804603682),f=o(f,l,d,p,e[_+13],12,-40341101),p=o(p,f,l,d,e[_+14],17,-1502002290),d=o(d,p,f,l,e[_+15],22,1236535329),l=a(l,d,p,f,e[_+1],5,-165796510),f=a(f,l,d,p,e[_+6],9,-1069501632),p=a(p,f,l,d,e[_+11],14,643717713),d=a(d,p,f,l,e[_+0],20,-373897302),l=a(l,d,p,f,e[_+5],5,-701558691),f=a(f,l,d,p,e[_+10],9,38016083),p=a(p,f,l,d,e[_+15],14,-660478335),d=a(d,p,f,l,e[_+4],20,-405537848),l=a(l,d,p,f,e[_+9],5,568446438),f=a(f,l,d,p,e[_+14],9,-1019803690),p=a(p,f,l,d,e[_+3],14,-187363961),d=a(d,p,f,l,e[_+8],20,1163531501),l=a(l,d,p,f,e[_+13],5,-1444681467),f=a(f,l,d,p,e[_+2],9,-51403784),p=a(p,f,l,d,e[_+7],14,1735328473),d=a(d,p,f,l,e[_+12],20,-1926607734),l=h(l,d,p,f,e[_+5],4,-378558),f=h(f,l,d,p,e[_+8],11,-2022574463),p=h(p,f,l,d,e[_+11],16,1839030562),d=h(d,p,f,l,e[_+14],23,-35309556),l=h(l,d,p,f,e[_+1],4,-1530992060),f=h(f,l,d,p,e[_+4],11,1272893353),p=h(p,f,l,d,e[_+7],16,-155497632),d=h(d,p,f,l,e[_+10],23,-1094730640),l=h(l,d,p,f,e[_+13],4,681279174),f=h(f,l,d,p,e[_+0],11,-358537222),p=h(p,f,l,d,e[_+3],16,-722521979),d=h(d,p,f,l,e[_+6],23,76029189),l=h(l,d,p,f,e[_+9],4,-640364487),f=h(f,l,d,p,e[_+12],11,-421815835),p=h(p,f,l,d,e[_+15],16,530742520),d=h(d,p,f,l,e[_+2],23,-995338651),l=c(l,d,p,f,e[_+0],6,-198630844),f=c(f,l,d,p,e[_+7],10,1126891415),p=c(p,f,l,d,e[_+14],15,-1416354905),d=c(d,p,f,l,e[_+5],21,-57434055),l=c(l,d,p,f,e[_+12],6,1700485571),f=c(f,l,d,p,e[_+3],10,-1894986606),p=c(p,f,l,d,e[_+10],15,-1051523),d=c(d,p,f,l,e[_+1],21,-2054922799),l=c(l,d,p,f,e[_+8],6,1873313359),f=c(f,l,d,p,e[_+15],10,-30611744),p=c(p,f,l,d,e[_+6],15,-1560198380),d=c(d,p,f,l,e[_+13],21,1309151649),l=c(l,d,p,f,e[_+4],6,-145523070),f=c(f,l,d,p,e[_+11],10,-1120210379),p=c(p,f,l,d,e[_+2],15,718787259),d=c(d,p,f,l,e[_+9],21,-343485551),l=t(l,s),d=t(d,i),p=t(p,r),f=t(f,u);return[l,d,p,f]},l={hexdigest:function(t){return i(u(n(t),8*t.length))},hash:function(t){return s(u(n(t),8*t.length))}};return l}),function(t,e){"function"==typeof n&&n.amd?n("strophe-utils",[],function(){return e()}):"object"==typeof exports?module.exports=e():t.stropheUtils=e()}(this,function(){var t={utf16to8:function(t){var e,n,s="",i=t.length;for(e=0;e<i;e++)n=t.charCodeAt(e),n>=0&&n<=127?s+=t.charAt(e):n>2047?(s+=String.fromCharCode(224|n>>12&15),s+=String.fromCharCode(128|n>>6&63),s+=String.fromCharCode(128|n>>0&63)):(s+=String.fromCharCode(192|n>>6&31),s+=String.fromCharCode(128|n>>0&63));return s},addCookies:function(t){var e,n,s,i,r,o,a;for(e in t||{})r="",o="",a="",n=t[e],s="object"==typeof n,i=escape(unescape(s?n.value:n)),s&&(r=n.expires?";expires="+n.expires:"",o=n.domain?";domain="+n.domain:"",a=n.path?";path="+n.path:""),document.cookie=e+"="+i+r+o+a}};return t}),function(t,s){if("function"==typeof n&&n.amd)n("strophe-core",["strophe-sha1","strophe-md5","strophe-utils"],function(){return s.apply(this,arguments)});else if("object"==typeof exports)module.exports=s(e("./sha1"),e("./md5"),e("./utils"));else{var i=s(t.SHA1,t.MD5,t.stropheUtils);t.Strophe=i.Strophe,t.$build=i.$build,t.$iq=i.$iq,t.$msg=i.$msg,t.$pres=i.$pres,t.SHA1=i.SHA1,t.MD5=i.MD5,t.b64_hmac_sha1=i.SHA1.b64_hmac_sha1,t.b64_sha1=i.SHA1.b64_sha1,t.str_hmac_sha1=i.SHA1.str_hmac_sha1,t.str_sha1=i.SHA1.str_sha1}}(this,function(t,e,n){function s(t,e){return new a.Builder(t,e)}function i(t){return new a.Builder("message",t)}function r(t){return new a.Builder("iq",t)}function o(t){return new a.Builder("presence",t)}var a;return a={VERSION:"1.2.16",NS:{HTTPBIND:"http://jabber.org/protocol/httpbind",BOSH:"urn:xmpp:xbosh",CLIENT:"jabber:client",AUTH:"jabber:iq:auth",ROSTER:"jabber:iq:roster",PROFILE:"jabber:iq:profile",DISCO_INFO:"http://jabber.org/protocol/disco#info",DISCO_ITEMS:"http://jabber.org/protocol/disco#items",MUC:"http://jabber.org/protocol/muc",SASL:"urn:ietf:params:xml:ns:xmpp-sasl",STREAM:"http://etherx.jabber.org/streams",FRAMING:"urn:ietf:params:xml:ns:xmpp-framing",BIND:"urn:ietf:params:xml:ns:xmpp-bind",SESSION:"urn:ietf:params:xml:ns:xmpp-session",VERSION:"jabber:iq:version",STANZAS:"urn:ietf:params:xml:ns:xmpp-stanzas",XHTML_IM:"http://jabber.org/protocol/xhtml-im",XHTML:"http://www.w3.org/1999/xhtml"},XHTML:{tags:["a","blockquote","br","cite","em","img","li","ol","p","span","strong","ul","body"],attributes:{a:["href"],blockquote:["style"],br:[],cite:["style"],em:[],img:["src","alt","style","height","width"],li:["style"],ol:["style"],p:["style"],span:["style"],strong:[],ul:["style"],body:[]},css:["background-color","color","font-family","font-size","font-style","font-weight","margin-left","margin-right","text-align","text-decoration"],validTag:function(t){for(var e=0;e<a.XHTML.tags.length;e++)if(t===a.XHTML.tags[e])return!0;return!1},validAttribute:function(t,e){if("undefined"!=typeof a.XHTML.attributes[t]&&a.XHTML.attributes[t].length>0)for(var n=0;n<a.XHTML.attributes[t].length;n++)if(e===a.XHTML.attributes[t][n])return!0;return!1},validCSS:function(t){for(var e=0;e<a.XHTML.css.length;e++)if(t===a.XHTML.css[e])return!0;return!1}},Status:{ERROR:0,CONNECTING:1,CONNFAIL:2,AUTHENTICATING:3,AUTHFAIL:4,CONNECTED:5,DISCONNECTED:6,DISCONNECTING:7,ATTACHED:8,REDIRECT:9,CONNTIMEOUT:10},ErrorCondition:{BAD_FORMAT:"bad-format",CONFLICT:"conflict",MISSING_JID_NODE:"x-strophe-bad-non-anon-jid",NO_AUTH_MECH:"no-auth-mech",UNKNOWN_REASON:"unknown"},LogLevel:{DEBUG:0,INFO:1,WARN:2,ERROR:3,FATAL:4},ElementType:{NORMAL:1,TEXT:3,CDATA:4,FRAGMENT:11},TIMEOUT:1.1,SECONDARY_TIMEOUT:.1,addNamespace:function(t,e){a.NS[t]=e},forEachChild:function(t,e,n){var s,i;for(s=0;s<t.childNodes.length;s++)i=t.childNodes[s],i.nodeType!==a.ElementType.NORMAL||e&&!this.isTagEqual(i,e)||n(i)},isTagEqual:function(t,e){return t.tagName===e},_xmlGenerator:null,_makeGenerator:function(){var t;return void 0===document.implementation.createDocument||document.implementation.createDocument&&document.documentMode&&document.documentMode<10?(t=this._getIEXmlDom(),t.appendChild(t.createElement("strophe"))):t=document.implementation.createDocument("jabber:client","strophe",null),t},xmlGenerator:function(){return a._xmlGenerator||(a._xmlGenerator=a._makeGenerator()),a._xmlGenerator},_getIEXmlDom:function(){for(var t=null,e=["Msxml2.DOMDocument.6.0","Msxml2.DOMDocument.5.0","Msxml2.DOMDocument.4.0","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument","MSXML.DOMDocument","Microsoft.XMLDOM"],n=0;n<e.length&&null===t;n++)try{t=new ActiveXObject(e[n])}catch(e){t=null}return t},xmlElement:function(t){if(!t)return null;var e,n,s,i=a.xmlGenerator().createElement(t);for(e=1;e<arguments.length;e++){var r=arguments[e];if(r)if("string"==typeof r||"number"==typeof r)i.appendChild(a.xmlTextNode(r));else if("object"==typeof r&&"function"==typeof r.sort)for(n=0;n<r.length;n++){var o=r[n];"object"==typeof o&&"function"==typeof o.sort&&void 0!==o[1]&&null!==o[1]&&i.setAttribute(o[0],o[1])}else if("object"==typeof r)for(s in r)r.hasOwnProperty(s)&&void 0!==r[s]&&null!==r[s]&&i.setAttribute(s,r[s])}return i},xmlescape:function(t){return t=t.replace(/\&/g,"&amp;"),t=t.replace(/</g,"&lt;"),t=t.replace(/>/g,"&gt;"),t=t.replace(/'/g,"&apos;"),t=t.replace(/"/g,"&quot;")},xmlunescape:function(t){return t=t.replace(/\&amp;/g,"&"),t=t.replace(/&lt;/g,"<"),t=t.replace(/&gt;/g,">"),t=t.replace(/&apos;/g,"'"),t=t.replace(/&quot;/g,'"')},xmlTextNode:function(t){return a.xmlGenerator().createTextNode(t)},xmlHtmlNode:function(t){var e;if(DOMParser){var n=new DOMParser;e=n.parseFromString(t,"text/xml")}else e=new ActiveXObject("Microsoft.XMLDOM"),e.async="false",e.loadXML(t);return e},getText:function(t){if(!t)return null;var e="";0===t.childNodes.length&&t.nodeType===a.ElementType.TEXT&&(e+=t.nodeValue);for(var n=0;n<t.childNodes.length;n++)t.childNodes[n].nodeType===a.ElementType.TEXT&&(e+=t.childNodes[n].nodeValue);return a.xmlescape(e)},copyElement:function(t){var e,n;if(t.nodeType===a.ElementType.NORMAL){for(n=a.xmlElement(t.tagName),e=0;e<t.attributes.length;e++)n.setAttribute(t.attributes[e].nodeName,t.attributes[e].value);for(e=0;e<t.childNodes.length;e++)n.appendChild(a.copyElement(t.childNodes[e]))}else t.nodeType===a.ElementType.TEXT&&(n=a.xmlGenerator().createTextNode(t.nodeValue));return n},createHtml:function(t){var e,n,s,i,r,o,h,c,u,l,d;if(t.nodeType===a.ElementType.NORMAL)if(i=t.nodeName.toLowerCase(),a.XHTML.validTag(i))try{for(n=a.xmlElement(i),e=0;e<a.XHTML.attributes[i].length;e++)if(r=a.XHTML.attributes[i][e],o=t.getAttribute(r),"undefined"!=typeof o&&null!==o&&""!==o&&o!==!1&&0!==o)if("style"===r&&"object"==typeof o&&"undefined"!=typeof o.cssText&&(o=o.cssText),"style"===r){for(h=[],c=o.split(";"),s=0;s<c.length;s++)u=c[s].split(":"),l=u[0].replace(/^\s*/,"").replace(/\s*$/,"").toLowerCase(),a.XHTML.validCSS(l)&&(d=u[1].replace(/^\s*/,"").replace(/\s*$/,""),h.push(l+": "+d));h.length>0&&(o=h.join("; "),n.setAttribute(r,o))}else n.setAttribute(r,o);for(e=0;e<t.childNodes.length;e++)n.appendChild(a.createHtml(t.childNodes[e]))}catch(t){n=a.xmlTextNode("")}else for(n=a.xmlGenerator().createDocumentFragment(),e=0;e<t.childNodes.length;e++)n.appendChild(a.createHtml(t.childNodes[e]));else if(t.nodeType===a.ElementType.FRAGMENT)for(n=a.xmlGenerator().createDocumentFragment(),e=0;e<t.childNodes.length;e++)n.appendChild(a.createHtml(t.childNodes[e]));else t.nodeType===a.ElementType.TEXT&&(n=a.xmlTextNode(t.nodeValue));return n},escapeNode:function(t){return"string"!=typeof t?t:t.replace(/^\s+|\s+$/g,"").replace(/\\/g,"\\5c").replace(/ /g,"\\20").replace(/\"/g,"\\22").replace(/\&/g,"\\26").replace(/\'/g,"\\27").replace(/\//g,"\\2f").replace(/:/g,"\\3a").replace(/</g,"\\3c").replace(/>/g,"\\3e").replace(/@/g,"\\40")},unescapeNode:function(t){return"string"!=typeof t?t:t.replace(/\\20/g," ").replace(/\\22/g,'"').replace(/\\26/g,"&").replace(/\\27/g,"'").replace(/\\2f/g,"/").replace(/\\3a/g,":").replace(/\\3c/g,"<").replace(/\\3e/g,">").replace(/\\40/g,"@").replace(/\\5c/g,"\\")},getNodeFromJid:function(t){return t.indexOf("@")<0?null:t.split("@")[0]},getDomainFromJid:function(t){var e=a.getBareJidFromJid(t);if(e.indexOf("@")<0)return e;var n=e.split("@");return n.splice(0,1),n.join("@")},getResourceFromJid:function(t){var e=t.split("/");return e.length<2?null:(e.splice(0,1),e.join("/"))},getBareJidFromJid:function(t){return t?t.split("/")[0]:null},_handleError:function(t){"undefined"!=typeof t.stack&&a.fatal(t.stack),t.sourceURL?a.fatal("error: "+this.handler+" "+t.sourceURL+":"+t.line+" - "+t.name+": "+t.message):t.fileName?a.fatal("error: "+this.handler+" "+t.fileName+":"+t.lineNumber+" - "+t.name+": "+t.message):a.fatal("error: "+t.message)},log:function(t,e){t===this.LogLevel.FATAL&&"object"==typeof window.console&&"function"==typeof window.console.error&&window.console.error(e)},debug:function(t){this.log(this.LogLevel.DEBUG,t)},info:function(t){this.log(this.LogLevel.INFO,t)},warn:function(t){this.log(this.LogLevel.WARN,t)},error:function(t){this.log(this.LogLevel.ERROR,t)},fatal:function(t){this.log(this.LogLevel.FATAL,t)},serialize:function(t){var e;if(!t)return null;"function"==typeof t.tree&&(t=t.tree());var n,s,i=t.nodeName;for(t.getAttribute("_realname")&&(i=t.getAttribute("_realname")),e="<"+i,n=0;n<t.attributes.length;n++)"_realname"!==t.attributes[n].nodeName&&(e+=" "+t.attributes[n].nodeName+"='"+a.xmlescape(t.attributes[n].value)+"'");if(t.childNodes.length>0){for(e+=">",n=0;n<t.childNodes.length;n++)switch(s=t.childNodes[n],s.nodeType){case a.ElementType.NORMAL:e+=a.serialize(s);break;case a.ElementType.TEXT:e+=a.xmlescape(s.nodeValue);break;case a.ElementType.CDATA:e+="<![CDATA["+s.nodeValue+"]]>"}e+="</"+i+">"}else e+="/>";return e},_requestId:0,_connectionPlugins:{},addConnectionPlugin:function(t,e){a._connectionPlugins[t]=e}},a.Builder=function(t,e){"presence"!==t&&"message"!==t&&"iq"!==t||(e&&!e.xmlns?e.xmlns=a.NS.CLIENT:e||(e={xmlns:a.NS.CLIENT})),this.nodeTree=a.xmlElement(t,e),this.node=this.nodeTree},a.Builder.prototype={tree:function(){return this.nodeTree},toString:function(){return a.serialize(this.nodeTree)},up:function(){return this.node=this.node.parentNode,this},root:function(){return this.node=this.nodeTree,this},attrs:function(t){for(var e in t)t.hasOwnProperty(e)&&(void 0===t[e]?this.node.removeAttribute(e):this.node.setAttribute(e,t[e]));return this},c:function(t,e,n){var s=a.xmlElement(t,e,n);return this.node.appendChild(s),"string"!=typeof n&&"number"!=typeof n&&(this.node=s),this},cnode:function(t){var e,n=a.xmlGenerator();try{e=void 0!==n.importNode}catch(t){e=!1}var s=e?n.importNode(t,!0):a.copyElement(t);return this.node.appendChild(s),this.node=s,this},t:function(t){var e=a.xmlTextNode(t);return this.node.appendChild(e),this},h:function(t){var e=document.createElement("body");e.innerHTML=t;for(var n=a.createHtml(e);n.childNodes.length>0;)this.node.appendChild(n.childNodes[0]);return this}},a.Handler=function(t,e,n,s,i,r,o){this.handler=t,this.ns=e,this.name=n,this.type=s,this.id=i,this.options=o||{matchBareFromJid:!1,ignoreNamespaceFragment:!1},this.options.matchBare&&(a.warn('The "matchBare" option is deprecated, use "matchBareFromJid" instead.'),this.options.matchBareFromJid=this.options.matchBare,delete this.options.matchBare),this.options.matchBareFromJid?this.from=r?a.getBareJidFromJid(r):null:this.from=r,this.user=!0},a.Handler.prototype={getNamespace:function(t){var e=t.getAttribute("xmlns");return e&&this.options.ignoreNamespaceFragment&&(e=e.split("#")[0]),e},namespaceMatch:function(t){var e=!1;if(!this.ns)return!0;var n=this;return a.forEachChild(t,null,function(t){n.getNamespace(t)===n.ns&&(e=!0)}),e=e||this.getNamespace(t)===this.ns},isMatch:function(t){var e=t.getAttribute("from");this.options.matchBareFromJid&&(e=a.getBareJidFromJid(e));var n=t.getAttribute("type");return!(!this.namespaceMatch(t)||this.name&&!a.isTagEqual(t,this.name)||this.type&&(Array.isArray(this.type)?this.type.indexOf(n)===-1:n!==this.type)||this.id&&t.getAttribute("id")!==this.id||this.from&&e!==this.from)},run:function(t){var e=null;try{e=this.handler(t)}catch(t){throw a._handleError(t),t}return e},toString:function(){return"{Handler: "+this.handler+"("+this.name+","+this.id+","+this.ns+")}"}},a.TimedHandler=function(t,e){this.period=t,this.handler=e,this.lastCalled=(new Date).getTime(),this.user=!0},a.TimedHandler.prototype={run:function(){return this.lastCalled=(new Date).getTime(),this.handler()},reset:function(){this.lastCalled=(new Date).getTime()},toString:function(){return"{TimedHandler: "+this.handler+"("+this.period+")}"}},a.Connection=function(t,e){this.service=t,this.options=e||{};var s=this.options.protocol||"";0===t.indexOf("ws:")||0===t.indexOf("wss:")||0===s.indexOf("ws")?this._proto=new a.Websocket(this):this._proto=new a.Bosh(this),this.jid="",this.domain=null,this.features=null,this._sasl_data={},this.do_session=!1,this.do_bind=!1,this.timedHandlers=[],this.handlers=[],this.removeTimeds=[],this.removeHandlers=[],this.addTimeds=[],this.addHandlers=[],this.protocolErrorHandlers={HTTP:{},websocket:{}},this._idleTimeout=null,this._disconnectTimeout=null,this.authenticated=!1,this.connected=!1,this.disconnecting=!1,this.do_authentication=!0,this.paused=!1,this.restored=!1,this._data=[],this._uniqueId=0,this._sasl_success_handler=null,this._sasl_failure_handler=null,this._sasl_challenge_handler=null,this.maxRetries=5,this._idleTimeout=setTimeout(function(){this._onIdle()}.bind(this),100),n.addCookies(this.options.cookies),this.registerSASLMechanisms(this.options.mechanisms);for(var i in a._connectionPlugins)if(a._connectionPlugins.hasOwnProperty(i)){var r=a._connectionPlugins[i],o=function(){};o.prototype=r,this[i]=new o,this[i].init(this)}},a.Connection.prototype={reset:function(){this._proto._reset(),this.do_session=!1,this.do_bind=!1,this.timedHandlers=[],this.handlers=[],this.removeTimeds=[],this.removeHandlers=[],this.addTimeds=[],this.addHandlers=[],this.authenticated=!1,this.connected=!1,this.disconnecting=!1,this.restored=!1,this._data=[],this._requests=[],this._uniqueId=0},pause:function(){this.paused=!0},resume:function(){this.paused=!1},getUniqueId:function(t){var e="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(t){var e=16*Math.random()|0,n="x"===t?e:3&e|8;return n.toString(16)});return"string"==typeof t||"number"==typeof t?e+":"+t:e+""},addProtocolErrorHandler:function(t,e,n){this.protocolErrorHandlers[t][e]=n},connect:function(t,e,n,s,i,r,o){this.jid=t,this.authzid=a.getBareJidFromJid(this.jid),this.authcid=o||a.getNodeFromJid(this.jid),this.pass=e,this.servtype="xmpp",this.connect_callback=n,this.disconnecting=!1,this.connected=!1,this.authenticated=!1,this.restored=!1,this.domain=a.getDomainFromJid(this.jid),this._changeConnectStatus(a.Status.CONNECTING,null),this._proto._connect(s,i,r)},attach:function(t,e,n,s,i,r,o){if(!(this._proto instanceof a.Bosh))throw{name:"StropheSessionError",message:'The "attach" method can only be used with a BOSH connection.'};this._proto._attach(t,e,n,s,i,r,o)},restore:function(t,e,n,s,i){if(!this._sessionCachingSupported())throw{name:"StropheSessionError",message:'The "restore" method can only be used with a BOSH connection.'};this._proto._restore(t,e,n,s,i)},_sessionCachingSupported:function(){if(this._proto instanceof a.Bosh){if(!JSON)return!1;try{sessionStorage.setItem("_strophe_","_strophe_"),sessionStorage.removeItem("_strophe_")}catch(t){return!1}return!0}return!1},xmlInput:function(t){},xmlOutput:function(t){},rawInput:function(t){},rawOutput:function(t){},nextValidRid:function(t){},send:function(t){if(null!==t){if("function"==typeof t.sort)for(var e=0;e<t.length;e++)this._queueData(t[e]);else"function"==typeof t.tree?this._queueData(t.tree()):this._queueData(t);this._proto._send()}},flush:function(){clearTimeout(this._idleTimeout),this._onIdle()},sendPresence:function(t,e,n,s){var i=null,r=this;"function"==typeof t.tree&&(t=t.tree());var o=t.getAttribute("id");if(o||(o=this.getUniqueId("sendPresence"),t.setAttribute("id",o)),"function"==typeof e||"function"==typeof n){var a=this.addHandler(function(t){i&&r.deleteTimedHandler(i);var s=t.getAttribute("type");"error"===s?n&&n(t):e&&e(t)},null,"presence",null,o);s&&(i=this.addTimedHandler(s,function(){return r.deleteHandler(a),n&&n(null),!1}))}return this.send(t),o},sendIQ:function(t,e,n,s){var i=null,r=this;"function"==typeof t.tree&&(t=t.tree());var o=t.getAttribute("id");if(o||(o=this.getUniqueId("sendIQ"),t.setAttribute("id",o)),"function"==typeof e||"function"==typeof n){var a=this.addHandler(function(t){i&&r.deleteTimedHandler(i);var s=t.getAttribute("type");if("result"===s)e&&e(t);else{if("error"!==s)throw{name:"StropheError",message:"Got bad IQ type of "+s};n&&n(t)}},null,"iq",["error","result"],o);s&&(i=this.addTimedHandler(s,function(){return r.deleteHandler(a),n&&n(null),!1}))}return this.send(t),o},_queueData:function(t){if(null===t||!t.tagName||!t.childNodes)throw{name:"StropheError",message:"Cannot queue non-DOMElement."};this._data.push(t)},_sendRestart:function(){this._data.push("restart"),this._proto._sendRestart(),this._idleTimeout=setTimeout(function(){this._onIdle()}.bind(this),100)},addTimedHandler:function(t,e){var n=new a.TimedHandler(t,e);return this.addTimeds.push(n),n},deleteTimedHandler:function(t){this.removeTimeds.push(t)},addHandler:function(t,e,n,s,i,r,o){var h=new a.Handler(t,e,n,s,i,r,o);return this.addHandlers.push(h),h},deleteHandler:function(t){this.removeHandlers.push(t);var e=this.addHandlers.indexOf(t);e>=0&&this.addHandlers.splice(e,1)},registerSASLMechanisms:function(t){this.mechanisms={},t=t||[a.SASLAnonymous,a.SASLExternal,a.SASLMD5,a.SASLOAuthBearer,a.SASLXOAuth2,a.SASLPlain,a.SASLSHA1],t.forEach(this.registerSASLMechanism.bind(this))},registerSASLMechanism:function(t){this.mechanisms[t.prototype.name]=t},disconnect:function(t){if(this._changeConnectStatus(a.Status.DISCONNECTING,t),a.info("Disconnect was called because: "+t),this.connected){var e=!1;this.disconnecting=!0,this.authenticated&&(e=o({xmlns:a.NS.CLIENT,type:"unavailable"})),this._disconnectTimeout=this._addSysTimedHandler(3e3,this._onDisconnectTimeout.bind(this)),this._proto._disconnect(e)}else a.info("Disconnect was called before Strophe connected to the server"),this._proto._abortAllRequests(),this._doDisconnect()},_changeConnectStatus:function(t,e,n){for(var s in a._connectionPlugins)if(a._connectionPlugins.hasOwnProperty(s)){var i=this[s];if(i.statusChanged)try{i.statusChanged(t,e)}catch(t){a.error(""+s+" plugin caused an exception changing status: "+t)}}if(this.connect_callback)try{this.connect_callback(t,e,n)}catch(t){a._handleError(t),a.error("User connection callback caused an exception: "+t)}},_doDisconnect:function(t){"number"==typeof this._idleTimeout&&clearTimeout(this._idleTimeout),null!==this._disconnectTimeout&&(this.deleteTimedHandler(this._disconnectTimeout),this._disconnectTimeout=null),a.info("_doDisconnect was called"),this._proto._doDisconnect(),this.authenticated=!1,this.disconnecting=!1,this.restored=!1,this.handlers=[],this.timedHandlers=[],this.removeTimeds=[],this.removeHandlers=[],this.addTimeds=[],this.addHandlers=[],this._changeConnectStatus(a.Status.DISCONNECTED,t),this.connected=!1},_dataRecv:function(t,e){a.info("_dataRecv called");var n=this._proto._reqToData(t);if(null!==n){this.xmlInput!==a.Connection.prototype.xmlInput&&(n.nodeName===this._proto.strip&&n.childNodes.length?this.xmlInput(n.childNodes[0]):this.xmlInput(n)),this.rawInput!==a.Connection.prototype.rawInput&&(e?this.rawInput(e):this.rawInput(a.serialize(n)));for(var s,i;this.removeHandlers.length>0;)i=this.removeHandlers.pop(),s=this.handlers.indexOf(i),s>=0&&this.handlers.splice(s,1);for(;this.addHandlers.length>0;)this.handlers.push(this.addHandlers.pop());if(this.disconnecting&&this._proto._emptyQueue())return void this._doDisconnect();var r,o,h=n.getAttribute("type");if(null!==h&&"terminate"===h){if(this.disconnecting)return;return r=n.getAttribute("condition"),o=n.getElementsByTagName("conflict"),null!==r?("remote-stream-error"===r&&o.length>0&&(r="conflict"),this._changeConnectStatus(a.Status.CONNFAIL,r)):this._changeConnectStatus(a.Status.CONNFAIL,a.ErrorCondition.UNKOWN_REASON),void this._doDisconnect(r)}var c=this;a.forEachChild(n,null,function(t){var e,n;for(n=c.handlers,c.handlers=[],e=0;e<n.length;e++){var s=n[e];try{!s.isMatch(t)||!c.authenticated&&s.user?c.handlers.push(s):s.run(t)&&c.handlers.push(s)}catch(t){a.warn("Removing Strophe handlers due to uncaught exception: "+t.message)}}})}},mechanisms:{},_connect_cb:function(t,e,n){a.info("_connect_cb was called"),this.connected=!0;var s;try{s=this._proto._reqToData(t)}catch(t){if("badformat"!==t)throw t;this._changeConnectStatus(a.Status.CONNFAIL,a.ErrorCondition.BAD_FORMAT),this._doDisconnect(a.ErrorCondition.BAD_FORMAT)}if(s){this.xmlInput!==a.Connection.prototype.xmlInput&&(s.nodeName===this._proto.strip&&s.childNodes.length?this.xmlInput(s.childNodes[0]):this.xmlInput(s)),this.rawInput!==a.Connection.prototype.rawInput&&(n?this.rawInput(n):this.rawInput(a.serialize(s)));var i=this._proto._connect_cb(s);if(i!==a.Status.CONNFAIL){var r;if(r=s.getElementsByTagNameNS?s.getElementsByTagNameNS(a.NS.STREAM,"features").length>0:s.getElementsByTagName("stream:features").length>0||s.getElementsByTagName("features").length>0,!r)return void this._proto._no_auth_received(e);var o,h,c=[],u=s.getElementsByTagName("mechanism");if(u.length>0)for(o=0;o<u.length;o++)h=a.getText(u[o]),this.mechanisms[h]&&c.push(this.mechanisms[h]);return 0===c.length&&0===s.getElementsByTagName("auth").length?void this._proto._no_auth_received(e):void(this.do_authentication!==!1&&this.authenticate(c))}}},sortMechanismsByPriority:function(t){var e,n,s,i;for(e=0;e<t.length-1;++e){for(s=e,n=e+1;n<t.length;++n)t[n].prototype.priority>t[s].prototype.priority&&(s=n);s!==e&&(i=t[e],t[e]=t[s],t[s]=i)}return t},_attemptSASLAuth:function(t){t=this.sortMechanismsByPriority(t||[]);
var e=0,n=!1;for(e=0;e<t.length;++e)if(t[e].prototype.test(this)){this._sasl_success_handler=this._addSysHandler(this._sasl_success_cb.bind(this),null,"success",null,null),this._sasl_failure_handler=this._addSysHandler(this._sasl_failure_cb.bind(this),null,"failure",null,null),this._sasl_challenge_handler=this._addSysHandler(this._sasl_challenge_cb.bind(this),null,"challenge",null,null),this._sasl_mechanism=new t[e],this._sasl_mechanism.onStart(this);var i=s("auth",{xmlns:a.NS.SASL,mechanism:this._sasl_mechanism.name});if(this._sasl_mechanism.isClientFirst){var r=this._sasl_mechanism.onChallenge(this,null);i.t(btoa(r))}this.send(i.tree()),n=!0;break}return n},_attemptLegacyAuth:function(){null===a.getNodeFromJid(this.jid)?(this._changeConnectStatus(a.Status.CONNFAIL,a.ErrorCondition.MISSING_JID_NODE),this.disconnect(a.ErrorCondition.MISSING_JID_NODE)):(this._changeConnectStatus(a.Status.AUTHENTICATING,null),this._addSysHandler(this._auth1_cb.bind(this),null,null,null,"_auth_1"),this.send(r({type:"get",to:this.domain,id:"_auth_1"}).c("query",{xmlns:a.NS.AUTH}).c("username",{}).t(a.getNodeFromJid(this.jid)).tree()))},authenticate:function(t){this._attemptSASLAuth(t)||this._attemptLegacyAuth()},_sasl_challenge_cb:function(t){var e=atob(a.getText(t)),n=this._sasl_mechanism.onChallenge(this,e),i=s("response",{xmlns:a.NS.SASL});return""!==n&&i.t(btoa(n)),this.send(i.tree()),!0},_auth1_cb:function(t){var e=r({type:"set",id:"_auth_2"}).c("query",{xmlns:a.NS.AUTH}).c("username",{}).t(a.getNodeFromJid(this.jid)).up().c("password").t(this.pass);return a.getResourceFromJid(this.jid)||(this.jid=a.getBareJidFromJid(this.jid)+"/strophe"),e.up().c("resource",{}).t(a.getResourceFromJid(this.jid)),this._addSysHandler(this._auth2_cb.bind(this),null,null,null,"_auth_2"),this.send(e.tree()),!1},_sasl_success_cb:function(t){if(this._sasl_data["server-signature"]){var e,n=atob(a.getText(t)),s=/([a-z]+)=([^,]+)(,|$)/,i=n.match(s);if("v"===i[1]&&(e=i[2]),e!==this._sasl_data["server-signature"])return this.deleteHandler(this._sasl_failure_handler),this._sasl_failure_handler=null,this._sasl_challenge_handler&&(this.deleteHandler(this._sasl_challenge_handler),this._sasl_challenge_handler=null),this._sasl_data={},this._sasl_failure_cb(null)}a.info("SASL authentication succeeded."),this._sasl_mechanism&&this._sasl_mechanism.onSuccess(),this.deleteHandler(this._sasl_failure_handler),this._sasl_failure_handler=null,this._sasl_challenge_handler&&(this.deleteHandler(this._sasl_challenge_handler),this._sasl_challenge_handler=null);var r=[],o=function(t,e){for(;t.length;)this.deleteHandler(t.pop());return this._sasl_auth1_cb.bind(this)(e),!1};return r.push(this._addSysHandler(function(t){o.bind(this)(r,t)}.bind(this),null,"stream:features",null,null)),r.push(this._addSysHandler(function(t){o.bind(this)(r,t)}.bind(this),a.NS.STREAM,"features",null,null)),this._sendRestart(),!1},_sasl_auth1_cb:function(t){this.features=t;var e,n;for(e=0;e<t.childNodes.length;e++)n=t.childNodes[e],"bind"===n.nodeName&&(this.do_bind=!0),"session"===n.nodeName&&(this.do_session=!0);if(!this.do_bind)return this._changeConnectStatus(a.Status.AUTHFAIL,null),!1;this._addSysHandler(this._sasl_bind_cb.bind(this),null,null,null,"_bind_auth_2");var s=a.getResourceFromJid(this.jid);return s?this.send(r({type:"set",id:"_bind_auth_2"}).c("bind",{xmlns:a.NS.BIND}).c("resource",{}).t(s).tree()):this.send(r({type:"set",id:"_bind_auth_2"}).c("bind",{xmlns:a.NS.BIND}).tree()),!1},_sasl_bind_cb:function(t){if("error"===t.getAttribute("type")){a.info("SASL binding failed.");var e,n=t.getElementsByTagName("conflict");return n.length>0&&(e=a.ErrorCondition.CONFLICT),this._changeConnectStatus(a.Status.AUTHFAIL,e,t),!1}var s,i=t.getElementsByTagName("bind");return i.length>0?(s=i[0].getElementsByTagName("jid"),void(s.length>0&&(this.jid=a.getText(s[0]),this.do_session?(this._addSysHandler(this._sasl_session_cb.bind(this),null,null,null,"_session_auth_2"),this.send(r({type:"set",id:"_session_auth_2"}).c("session",{xmlns:a.NS.SESSION}).tree())):(this.authenticated=!0,this._changeConnectStatus(a.Status.CONNECTED,null))))):(a.info("SASL binding failed."),this._changeConnectStatus(a.Status.AUTHFAIL,null,t),!1)},_sasl_session_cb:function(t){if("result"===t.getAttribute("type"))this.authenticated=!0,this._changeConnectStatus(a.Status.CONNECTED,null);else if("error"===t.getAttribute("type"))return a.info("Session creation failed."),this._changeConnectStatus(a.Status.AUTHFAIL,null,t),!1;return!1},_sasl_failure_cb:function(t){return this._sasl_success_handler&&(this.deleteHandler(this._sasl_success_handler),this._sasl_success_handler=null),this._sasl_challenge_handler&&(this.deleteHandler(this._sasl_challenge_handler),this._sasl_challenge_handler=null),this._sasl_mechanism&&this._sasl_mechanism.onFailure(),this._changeConnectStatus(a.Status.AUTHFAIL,null,t),!1},_auth2_cb:function(t){return"result"===t.getAttribute("type")?(this.authenticated=!0,this._changeConnectStatus(a.Status.CONNECTED,null)):"error"===t.getAttribute("type")&&(this._changeConnectStatus(a.Status.AUTHFAIL,null,t),this.disconnect("authentication failed")),!1},_addSysTimedHandler:function(t,e){var n=new a.TimedHandler(t,e);return n.user=!1,this.addTimeds.push(n),n},_addSysHandler:function(t,e,n,s,i){var r=new a.Handler(t,e,n,s,i);return r.user=!1,this.addHandlers.push(r),r},_onDisconnectTimeout:function(){return a.info("_onDisconnectTimeout was called"),this._changeConnectStatus(a.Status.CONNTIMEOUT,null),this._proto._onDisconnectTimeout(),this._doDisconnect(),!1},_onIdle:function(){for(var t,e,n,s;this.addTimeds.length>0;)this.timedHandlers.push(this.addTimeds.pop());for(;this.removeTimeds.length>0;)e=this.removeTimeds.pop(),t=this.timedHandlers.indexOf(e),t>=0&&this.timedHandlers.splice(t,1);var i=(new Date).getTime();for(s=[],t=0;t<this.timedHandlers.length;t++)e=this.timedHandlers[t],!this.authenticated&&e.user||(n=e.lastCalled+e.period,n-i<=0?e.run()&&s.push(e):s.push(e));this.timedHandlers=s,clearTimeout(this._idleTimeout),this._proto._onIdle(),this.connected&&(this._idleTimeout=setTimeout(function(){this._onIdle()}.bind(this),100))}},a.SASLMechanism=function(t,e,n){this.name=t,this.isClientFirst=e,this.priority=n},a.SASLMechanism.prototype={test:function(t){return!0},onStart:function(t){this._connection=t},onChallenge:function(t,e){throw new Error("You should implement challenge handling!")},onFailure:function(){this._connection=null},onSuccess:function(){this._connection=null}},a.SASLAnonymous=function(){},a.SASLAnonymous.prototype=new a.SASLMechanism("ANONYMOUS",!1,20),a.SASLAnonymous.prototype.test=function(t){return null===t.authcid},a.SASLPlain=function(){},a.SASLPlain.prototype=new a.SASLMechanism("PLAIN",!0,50),a.SASLPlain.prototype.test=function(t){return null!==t.authcid},a.SASLPlain.prototype.onChallenge=function(t){var e=t.authzid;return e+="\0",e+=t.authcid,e+="\0",e+=t.pass,n.utf16to8(e)},a.SASLSHA1=function(){},a.SASLSHA1.prototype=new a.SASLMechanism("SCRAM-SHA-1",!0,70),a.SASLSHA1.prototype.test=function(t){return null!==t.authcid},a.SASLSHA1.prototype.onChallenge=function(s,i,r){var o=r||e.hexdigest(1234567890*Math.random()),a="n="+n.utf16to8(s.authcid);return a+=",r=",a+=o,s._sasl_data.cnonce=o,s._sasl_data["client-first-message-bare"]=a,a="n,,"+a,this.onChallenge=function(e,s){for(var i,r,o,a,h,c,u,l,d,p,f,_,m="c=biws,",g=e._sasl_data["client-first-message-bare"]+","+s+",",S=e._sasl_data.cnonce,b=/([a-z]+)=([^,]+)(,|$)/;s.match(b);){var y=s.match(b);switch(s=s.replace(y[0],""),y[1]){case"r":i=y[2];break;case"s":r=y[2];break;case"i":o=y[2]}}if(i.substr(0,S.length)!==S)return e._sasl_data={},e._sasl_failure_cb();for(m+="r="+i,g+=m,r=atob(r),r+="\0\0\0",d=n.utf16to8(e.pass),a=c=t.core_hmac_sha1(d,r),u=1;u<o;u++){for(h=t.core_hmac_sha1(d,t.binb2str(c)),l=0;l<5;l++)a[l]^=h[l];c=h}for(a=t.binb2str(a),p=t.core_hmac_sha1(a,"Client Key"),f=t.str_hmac_sha1(a,"Server Key"),_=t.core_hmac_sha1(t.str_sha1(t.binb2str(p)),g),e._sasl_data["server-signature"]=t.b64_hmac_sha1(f,g),l=0;l<5;l++)p[l]^=_[l];return m+=",p="+btoa(t.binb2str(p))}.bind(this),a},a.SASLMD5=function(){},a.SASLMD5.prototype=new a.SASLMechanism("DIGEST-MD5",!1,60),a.SASLMD5.prototype.test=function(t){return null!==t.authcid},a.SASLMD5.prototype._quote=function(t){return'"'+t.replace(/\\/g,"\\\\").replace(/"/g,'\\"')+'"'},a.SASLMD5.prototype.onChallenge=function(t,s,i){for(var r,o=/([a-z]+)=("[^"]+"|[^,"]+)(?:,|$)/,a=i||e.hexdigest(""+1234567890*Math.random()),h="",c=null,u="",l="";s.match(o);)switch(r=s.match(o),s=s.replace(r[0],""),r[2]=r[2].replace(/^"(.+)"$/,"$1"),r[1]){case"realm":h=r[2];break;case"nonce":u=r[2];break;case"qop":l=r[2];break;case"host":c=r[2]}var d=t.servtype+"/"+t.domain;null!==c&&(d=d+"/"+c);var p=n.utf16to8(t.authcid+":"+h+":"+this._connection.pass),f=e.hash(p)+":"+u+":"+a,_="AUTHENTICATE:"+d,m="";return m+="charset=utf-8,",m+="username="+this._quote(n.utf16to8(t.authcid))+",",m+="realm="+this._quote(h)+",",m+="nonce="+this._quote(u)+",",m+="nc=00000001,",m+="cnonce="+this._quote(a)+",",m+="digest-uri="+this._quote(d)+",",m+="response="+e.hexdigest(e.hexdigest(f)+":"+u+":00000001:"+a+":auth:"+e.hexdigest(_))+",",m+="qop=auth",this.onChallenge=function(){return""},m},a.SASLOAuthBearer=function(){},a.SASLOAuthBearer.prototype=new a.SASLMechanism("OAUTHBEARER",!0,40),a.SASLOAuthBearer.prototype.test=function(t){return null!==t.pass},a.SASLOAuthBearer.prototype.onChallenge=function(t){var e="n,";return null!==t.authcid&&(e=e+"a="+t.authzid),e+=",",e+="",e+="auth=Bearer ",e+=t.pass,e+="",e+="",n.utf16to8(e)},a.SASLExternal=function(){},a.SASLExternal.prototype=new a.SASLMechanism("EXTERNAL",!0,10),a.SASLExternal.prototype.onChallenge=function(t){return t.authcid===t.authzid?"":t.authzid},a.SASLXOAuth2=function(){},a.SASLXOAuth2.prototype=new a.SASLMechanism("X-OAUTH2",!0,30),a.SASLXOAuth2.prototype.test=function(t){return null!==t.pass},a.SASLXOAuth2.prototype.onChallenge=function(t){var e="\0";return null!==t.authcid&&(e+=t.authzid),e+="\0",e+=t.pass,n.utf16to8(e)},{Strophe:a,$build:s,$iq:r,$msg:i,$pres:o,SHA1:t,MD5:e,b64_hmac_sha1:t.b64_hmac_sha1,b64_sha1:t.b64_sha1,str_hmac_sha1:t.str_hmac_sha1,str_sha1:t.str_sha1}}),function(t,s){if("function"==typeof n&&n.amd)n("strophe-bosh",["strophe-core"],function(t){return s(t.Strophe,t.$build)});else{if("object"!=typeof exports)return s(Strophe,$build);var i=e("./core");module.exports=s(i.Strophe,i.$build)}}(this,function(t,e){return t.Request=function(e,n,s,i){this.id=++t._requestId,this.xmlData=e,this.data=t.serialize(e),this.origFunc=n,this.func=n,this.rid=s,this.date=NaN,this.sends=i||0,this.abort=!1,this.dead=null,this.age=function(){if(!this.date)return 0;var t=new Date;return(t-this.date)/1e3},this.timeDead=function(){if(!this.dead)return 0;var t=new Date;return(t-this.dead)/1e3},this.xhr=this._newXHR()},t.Request.prototype={getResponse:function(){var e=null;if(this.xhr.responseXML&&this.xhr.responseXML.documentElement){if(e=this.xhr.responseXML.documentElement,"parsererror"===e.tagName)throw t.error("invalid response received"),t.error("responseText: "+this.xhr.responseText),t.error("responseXML: "+t.serialize(this.xhr.responseXML)),"parsererror"}else if(this.xhr.responseText){if(t.debug("Got responseText but no responseXML; attempting to parse it with DOMParser..."),e=(new DOMParser).parseFromString(this.xhr.responseText,"application/xml").documentElement,!e)throw new Error("Parsing produced null node");if(e.querySelector("parsererror"))throw t.error("invalid response received: "+e.querySelector("parsererror").textContent),t.error("responseText: "+this.xhr.responseText),"badformat"}return e},_newXHR:function(){var t=null;return window.XMLHttpRequest?(t=new XMLHttpRequest,t.overrideMimeType&&t.overrideMimeType("text/xml; charset=utf-8")):window.ActiveXObject&&(t=new ActiveXObject("Microsoft.XMLHTTP")),t.onreadystatechange=this.func.bind(null,this),t}},t.Bosh=function(t){this._conn=t,this.rid=Math.floor(4294967295*Math.random()),this.sid=null,this.hold=1,this.wait=60,this.window=5,this.errors=0,this.inactivity=null,this.lastResponseHeaders=null,this._requests=[]},t.Bosh.prototype={strip:null,_buildBody:function(){var n=e("body",{rid:this.rid++,xmlns:t.NS.HTTPBIND});return null!==this.sid&&n.attrs({sid:this.sid}),this._conn.options.keepalive&&this._conn._sessionCachingSupported()&&this._cacheSession(),n},_reset:function(){this.rid=Math.floor(4294967295*Math.random()),this.sid=null,this.errors=0,this._conn._sessionCachingSupported()&&window.sessionStorage.removeItem("strophe-bosh-session"),this._conn.nextValidRid(this.rid)},_connect:function(e,n,s){this.wait=e||this.wait,this.hold=n||this.hold,this.errors=0;var i=this._buildBody().attrs({to:this._conn.domain,"xml:lang":"en",wait:this.wait,hold:this.hold,content:"text/xml; charset=utf-8",ver:"1.6","xmpp:version":"1.0","xmlns:xmpp":t.NS.BOSH});s&&i.attrs({route:s});var r=this._conn._connect_cb;this._requests.push(new t.Request(i.tree(),this._onRequestStateChange.bind(this,r.bind(this._conn)),i.tree().getAttribute("rid"))),this._throttledRequestHandler()},_attach:function(e,n,s,i,r,o,a){this._conn.jid=e,this.sid=n,this.rid=s,this._conn.connect_callback=i,this._conn.domain=t.getDomainFromJid(this._conn.jid),this._conn.authenticated=!0,this._conn.connected=!0,this.wait=r||this.wait,this.hold=o||this.hold,this.window=a||this.window,this._conn._changeConnectStatus(t.Status.ATTACHED,null)},_restore:function(e,n,s,i,r){var o=JSON.parse(window.sessionStorage.getItem("strophe-bosh-session"));if(!("undefined"!=typeof o&&null!==o&&o.rid&&o.sid&&o.jid&&("undefined"==typeof e||null===e||t.getBareJidFromJid(o.jid)===t.getBareJidFromJid(e)||null===t.getNodeFromJid(e)&&t.getDomainFromJid(o.jid)===e)))throw{name:"StropheSessionError",message:"_restore: no restoreable session."};this._conn.restored=!0,this._attach(o.jid,o.sid,o.rid,n,s,i,r)},_cacheSession:function(){this._conn.authenticated?this._conn.jid&&this.rid&&this.sid&&window.sessionStorage.setItem("strophe-bosh-session",JSON.stringify({jid:this._conn.jid,rid:this.rid,sid:this.sid})):window.sessionStorage.removeItem("strophe-bosh-session")},_connect_cb:function(e){var n,s,i=e.getAttribute("type");if(null!==i&&"terminate"===i)return n=e.getAttribute("condition"),t.error("BOSH-Connection failed: "+n),s=e.getElementsByTagName("conflict"),null!==n?("remote-stream-error"===n&&s.length>0&&(n="conflict"),this._conn._changeConnectStatus(t.Status.CONNFAIL,n)):this._conn._changeConnectStatus(t.Status.CONNFAIL,"unknown"),this._conn._doDisconnect(n),t.Status.CONNFAIL;this.sid||(this.sid=e.getAttribute("sid"));var r=e.getAttribute("requests");r&&(this.window=parseInt(r,10));var o=e.getAttribute("hold");o&&(this.hold=parseInt(o,10));var a=e.getAttribute("wait");a&&(this.wait=parseInt(a,10));var h=e.getAttribute("inactivity");h&&(this.inactivity=parseInt(h,10))},_disconnect:function(t){this._sendTerminate(t)},_doDisconnect:function(){this.sid=null,this.rid=Math.floor(4294967295*Math.random()),this._conn._sessionCachingSupported()&&window.sessionStorage.removeItem("strophe-bosh-session"),this._conn.nextValidRid(this.rid)},_emptyQueue:function(){return 0===this._requests.length},_callProtocolErrorHandlers:function(t){var e,n=this._getRequestStatus(t);e=this._conn.protocolErrorHandlers.HTTP[n],e&&e.call(this,n)},_hitError:function(e){this.errors++,t.warn("request errored, status: "+e+", number of errors: "+this.errors),this.errors>4&&this._conn._onDisconnectTimeout()},_no_auth_received:function(e){t.warn("Server did not yet offer a supported authentication mechanism. Sending a blank poll request."),e=e?e.bind(this._conn):this._conn._connect_cb.bind(this._conn);var n=this._buildBody();this._requests.push(new t.Request(n.tree(),this._onRequestStateChange.bind(this,e),n.tree().getAttribute("rid"))),this._throttledRequestHandler()},_onDisconnectTimeout:function(){this._abortAllRequests()},_abortAllRequests:function(){for(var t;this._requests.length>0;)t=this._requests.pop(),t.abort=!0,t.xhr.abort(),t.xhr.onreadystatechange=function(){}},_onIdle:function(){var e=this._conn._data;if(this._conn.authenticated&&0===this._requests.length&&0===e.length&&!this._conn.disconnecting&&(t.info("no requests during idle cycle, sending blank request"),e.push(null)),!this._conn.paused){if(this._requests.length<2&&e.length>0){for(var n=this._buildBody(),s=0;s<e.length;s++)null!==e[s]&&("restart"===e[s]?n.attrs({to:this._conn.domain,"xml:lang":"en","xmpp:restart":"true","xmlns:xmpp":t.NS.BOSH}):n.cnode(e[s]).up());delete this._conn._data,this._conn._data=[],this._requests.push(new t.Request(n.tree(),this._onRequestStateChange.bind(this,this._conn._dataRecv.bind(this._conn)),n.tree().getAttribute("rid"))),this._throttledRequestHandler()}if(this._requests.length>0){var i=this._requests[0].age();null!==this._requests[0].dead&&this._requests[0].timeDead()>Math.floor(t.SECONDARY_TIMEOUT*this.wait)&&this._throttledRequestHandler(),i>Math.floor(t.TIMEOUT*this.wait)&&(t.warn("Request "+this._requests[0].id+" timed out, over "+Math.floor(t.TIMEOUT*this.wait)+" seconds since last activity"),this._throttledRequestHandler())}}},_getRequestStatus:function(e,n){var s;if(4===e.xhr.readyState)try{s=e.xhr.status}catch(e){t.error("Caught an error while retrieving a request's status, reqStatus: "+s)}return"undefined"==typeof s&&(s="number"==typeof n?n:0),s},_onRequestStateChange:function(e,n){if(t.debug("request id "+n.id+"."+n.sends+" state changed to "+n.xhr.readyState),n.abort)return void(n.abort=!1);if(4===n.xhr.readyState){var s=this._getRequestStatus(n);if(this.lastResponseHeaders=n.xhr.getAllResponseHeaders(),this.disconnecting&&s>=400)return this._hitError(s),void this._callProtocolErrorHandlers(n);var i=s>0&&s<500,r=n.sends>this._conn.maxRetries;if((i||r)&&(this._removeRequest(n),t.debug("request id "+n.id+" should now be removed")),200===s){var o=this._requests[0]===n,a=this._requests[1]===n;(a||o&&this._requests.length>0&&this._requests[0].age()>Math.floor(t.SECONDARY_TIMEOUT*this.wait))&&this._restartRequest(0),this._conn.nextValidRid(Number(n.rid)+1),t.debug("request id "+n.id+"."+n.sends+" got 200"),e(n),this.errors=0}else 0===s||s>=400&&s<600||s>=12e3?(t.error("request id "+n.id+"."+n.sends+" error "+s+" happened"),this._hitError(s),this._callProtocolErrorHandlers(n),s>=400&&s<500&&(this._conn._changeConnectStatus(t.Status.DISCONNECTING,null),this._conn._doDisconnect())):t.error("request id "+n.id+"."+n.sends+" error "+s+" happened");i||r?r&&!this._conn.connected&&this._conn._changeConnectStatus(t.Status.CONNFAIL,"giving-up"):this._throttledRequestHandler()}},_processRequest:function(e){var n=this,s=this._requests[e],i=this._getRequestStatus(s,-1);if(s.sends>this._conn.maxRetries)return void this._conn._onDisconnectTimeout();var r=s.age(),o=!isNaN(r)&&r>Math.floor(t.TIMEOUT*this.wait),a=null!==s.dead&&s.timeDead()>Math.floor(t.SECONDARY_TIMEOUT*this.wait),h=4===s.xhr.readyState&&(i<1||i>=500);if((o||a||h)&&(a&&t.error("Request "+this._requests[e].id+" timed out (secondary), restarting"),s.abort=!0,s.xhr.abort(),s.xhr.onreadystatechange=function(){},this._requests[e]=new t.Request(s.xmlData,s.origFunc,s.rid,s.sends),s=this._requests[e]),0===s.xhr.readyState){t.debug("request id "+s.id+"."+s.sends+" posting");try{var c=this._conn.options.contentType||"text/xml; charset=utf-8";s.xhr.open("POST",this._conn.service,!this._conn.options.sync),"undefined"!=typeof s.xhr.setRequestHeader&&s.xhr.setRequestHeader("Content-Type",c),this._conn.options.withCredentials&&(s.xhr.withCredentials=!0)}catch(e){return t.error("XHR open failed: "+e.toString()),this._conn.connected||this._conn._changeConnectStatus(t.Status.CONNFAIL,"bad-service"),void this._conn.disconnect()}var u=function(){if(s.date=new Date,n._conn.options.customHeaders){var t=n._conn.options.customHeaders;for(var e in t)t.hasOwnProperty(e)&&s.xhr.setRequestHeader(e,t[e])}s.xhr.send(s.data)};if(s.sends>1){var l=1e3*Math.min(Math.floor(t.TIMEOUT*this.wait),Math.pow(s.sends,3));setTimeout(function(){u()},l)}else u();s.sends++,this._conn.xmlOutput!==t.Connection.prototype.xmlOutput&&(s.xmlData.nodeName===this.strip&&s.xmlData.childNodes.length?this._conn.xmlOutput(s.xmlData.childNodes[0]):this._conn.xmlOutput(s.xmlData)),this._conn.rawOutput!==t.Connection.prototype.rawOutput&&this._conn.rawOutput(s.data)}else t.debug("_processRequest: "+(0===e?"first":"second")+" request has readyState of "+s.xhr.readyState)},_removeRequest:function(e){t.debug("removing request");var n;for(n=this._requests.length-1;n>=0;n--)e===this._requests[n]&&this._requests.splice(n,1);e.xhr.onreadystatechange=function(){},this._throttledRequestHandler()},_restartRequest:function(t){var e=this._requests[t];null===e.dead&&(e.dead=new Date),this._processRequest(t)},_reqToData:function(t){try{return t.getResponse()}catch(t){if("parsererror"!==t)throw t;this._conn.disconnect("strophe-parsererror")}},_sendTerminate:function(e){t.info("_sendTerminate was called");var n=this._buildBody().attrs({type:"terminate"});e&&n.cnode(e.tree());var s=new t.Request(n.tree(),this._onRequestStateChange.bind(this,this._conn._dataRecv.bind(this._conn)),n.tree().getAttribute("rid"));this._requests.push(s),this._throttledRequestHandler()},_send:function(){clearTimeout(this._conn._idleTimeout),this._throttledRequestHandler(),this._conn._idleTimeout=setTimeout(function(){this._onIdle()}.bind(this._conn),100)},_sendRestart:function(){this._throttledRequestHandler(),clearTimeout(this._conn._idleTimeout)},_throttledRequestHandler:function(){this._requests?t.debug("_throttledRequestHandler called with "+this._requests.length+" requests"):t.debug("_throttledRequestHandler called with undefined requests"),this._requests&&0!==this._requests.length&&(this._requests.length>0&&this._processRequest(0),this._requests.length>1&&Math.abs(this._requests[0].rid-this._requests[1].rid)<this.window&&this._processRequest(1))}},t}),function(t,s){if("function"==typeof n&&n.amd)n("strophe-websocket",["strophe-core"],function(t){return s(t.Strophe,t.$build)});else{if("object"!=typeof exports)return s(Strophe,$build);var i=e("./core");module.exports=s(i.Strophe,i.$build)}}(this,function(t,e){return t.Websocket=function(t){this._conn=t,this.strip="wrapper";var e=t.service;if(0!==e.indexOf("ws:")&&0!==e.indexOf("wss:")){var n="";n+="ws"===t.options.protocol&&"https:"!==window.location.protocol?"ws":"wss",n+="://"+window.location.host,n+=0!==e.indexOf("/")?window.location.pathname+e:e,t.service=n}},t.Websocket.prototype={_buildStream:function(){return e("open",{xmlns:t.NS.FRAMING,to:this._conn.domain,version:"1.0"})},_check_streamerror:function(e,n){var s;if(s=e.getElementsByTagNameNS?e.getElementsByTagNameNS(t.NS.STREAM,"error"):e.getElementsByTagName("stream:error"),0===s.length)return!1;for(var i=s[0],r="",o="",a="urn:ietf:params:xml:ns:xmpp-streams",h=0;h<i.childNodes.length;h++){var c=i.childNodes[h];if(c.getAttribute("xmlns")!==a)break;"text"===c.nodeName?o=c.textContent:r=c.nodeName}var u="WebSocket stream error: ";return u+=r?r:"unknown",o&&(u+=" - "+o),t.error(u),this._conn._changeConnectStatus(n,r),this._conn._doDisconnect(),!0},_reset:function(){},_connect:function(){this._closeSocket(),this.socket=new WebSocket(this._conn.service,"xmpp"),this.socket.onopen=this._onOpen.bind(this),this.socket.onerror=this._onError.bind(this),this.socket.onclose=this._onClose.bind(this),this.socket.onmessage=this._connect_cb_wrapper.bind(this)},_connect_cb:function(e){var n=this._check_streamerror(e,t.Status.CONNFAIL);if(n)return t.Status.CONNFAIL},_handleStreamStart:function(e){var n=!1,s=e.getAttribute("xmlns");"string"!=typeof s?n="Missing xmlns in <open />":s!==t.NS.FRAMING&&(n="Wrong xmlns in <open />: "+s);var i=e.getAttribute("version");return"string"!=typeof i?n="Missing version in <open />":"1.0"!==i&&(n="Wrong version in <open />: "+i),!n||(this._conn._changeConnectStatus(t.Status.CONNFAIL,n),this._conn._doDisconnect(),!1)},_connect_cb_wrapper:function(e){if(0===e.data.indexOf("<open ")||0===e.data.indexOf("<?xml")){var n=e.data.replace(/^(<\?.*?\?>\s*)*/,"");if(""===n)return;var s=(new DOMParser).parseFromString(n,"text/xml").documentElement;this._conn.xmlInput(s),this._conn.rawInput(e.data),this._handleStreamStart(s)&&this._connect_cb(s)}else if(0===e.data.indexOf("<close ")){var i=(new DOMParser).parseFromString(e.data,"text/xml").documentElement;this._conn.xmlInput(i),this._conn.rawInput(e.data);var r=i.getAttribute("see-other-uri");if(r){var o=this._conn.service,a=o.indexOf("wss:")>=0&&r.indexOf("wss:")>=0||o.indexOf("ws:")>=0;a&&(this._conn._changeConnectStatus(t.Status.REDIRECT,"Received see-other-uri, resetting connection"),this._conn.reset(),this._conn.service=r,this._connect())}else this._conn._changeConnectStatus(t.Status.CONNFAIL,"Received closing stream"),this._conn._doDisconnect()}else{var h=this._streamWrap(e.data),c=(new DOMParser).parseFromString(h,"text/xml").documentElement;this.socket.onmessage=this._onMessage.bind(this),this._conn._connect_cb(c,null,e.data)}},_disconnect:function(n){if(this.socket&&this.socket.readyState!==WebSocket.CLOSED){n&&this._conn.send(n);var s=e("close",{xmlns:t.NS.FRAMING});this._conn.xmlOutput(s.tree());var i=t.serialize(s);this._conn.rawOutput(i);try{this.socket.send(i)}catch(e){t.info("Couldn't send <close /> tag.")}}this._conn._doDisconnect()},_doDisconnect:function(){t.info("WebSockets _doDisconnect was called"),this._closeSocket()},_streamWrap:function(t){return"<wrapper>"+t+"</wrapper>"},_closeSocket:function(){if(this.socket)try{this.socket.onerror=null,this.socket.close()}catch(t){}this.socket=null},_emptyQueue:function(){return!0},_onClose:function(e){this._conn.connected&&!this._conn.disconnecting?(t.error("Websocket closed unexpectedly"),this._conn._doDisconnect()):e&&1006===e.code&&!this._conn.connected&&this.socket?(t.error("Websocket closed unexcectedly"),this._conn._changeConnectStatus(t.Status.CONNFAIL,"The WebSocket connection could not be established or was disconnected."),this._conn._doDisconnect()):t.info("Websocket closed")},_no_auth_received:function(e){t.error("Server did not offer a supported authentication mechanism"),this._changeConnectStatus(t.Status.CONNFAIL,t.ErrorCondition.NO_AUTH_MECH),e&&e.call(this._conn),this._conn._doDisconnect()},_onDisconnectTimeout:function(){},_abortAllRequests:function(){},_onError:function(e){t.error("Websocket error "+e),this._conn._changeConnectStatus(t.Status.CONNFAIL,"The WebSocket connection could not be established or was disconnected."),this._disconnect()},_onIdle:function(){var e=this._conn._data;if(e.length>0&&!this._conn.paused){for(var n=0;n<e.length;n++)if(null!==e[n]){var s,i;s="restart"===e[n]?this._buildStream().tree():e[n],i=t.serialize(s),this._conn.xmlOutput(s),this._conn.rawOutput(i),this.socket.send(i)}this._conn._data=[]}},_onMessage:function(e){var n,s,i='<close xmlns="urn:ietf:params:xml:ns:xmpp-framing" />';if(e.data===i)return this._conn.rawInput(i),this._conn.xmlInput(e),void(this._conn.disconnecting||this._conn._doDisconnect());if(0===e.data.search("<open ")){if(n=(new DOMParser).parseFromString(e.data,"text/xml").documentElement,!this._handleStreamStart(n))return}else s=this._streamWrap(e.data),n=(new DOMParser).parseFromString(s,"text/xml").documentElement;return this._check_streamerror(n,t.Status.ERROR)?void 0:this._conn.disconnecting&&"presence"===n.firstChild.nodeName&&"unavailable"===n.firstChild.getAttribute("type")?(this._conn.xmlInput(n),void this._conn.rawInput(t.serialize(n))):void this._conn._dataRecv(n,e.data)},_onOpen:function(){t.info("Websocket open");var e=this._buildStream();this._conn.xmlOutput(e.tree());var n=t.serialize(e);this._conn.rawOutput(n),this.socket.send(n)},_reqToData:function(t){return t},_send:function(){this._conn.flush()},_sendRestart:function(){clearTimeout(this._conn._idleTimeout),this._conn._onIdle.bind(this._conn)()}},t}),function(t){if("function"==typeof n&&n.amd)n("strophe",["strophe-core","strophe-bosh","strophe-websocket"],function(t){return t});else if("object"==typeof exports){var s=e("./core");e("./bosh"),e("./websocket"),module.exports=s}}(this),e(["strophe-polyfill"]),e("strophe")});